<?php

declare(strict_types=1);

namespace Meibuyu\Common\UploadOss;

use Hyperf\DbConnection\Model\Model;

/**
 * oss模型类 OssFiles
 * @package App\Model
 * @property integer $id
 * @property string $type 文件类型
 * @property string $module 模块名
 * @property string $source_name 源文件名
 * @property string $name 文件名
 * @property string $path 文件路径
 * @property string $user_id 用户id
 * @property string $ext 文件后缀
 * @property string $size 文件大小
 * @property string $created_at
 */
class FileModel extends Model
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'oss_files';

    const UPDATED_AT = null;

    protected $fillable = ['type', 'module', 'source_name', 'name', 'path', 'user_id', 'ext', 'size'];

}