<?php
/**
 * Created by PhpStorm.
 * User: 姜克保
 * Date: 2020/5/20
 * Time: 15:48
 */

namespace Meibuyu\Micro\Service\Interfaces;

use phpDocumentor\Reflection\Types\Integer;

interface DispatchPlanServiceInterface
{

    /**
     * description:获取退税任务列表
     * author: fuyunnan
     * @param array $conditions 筛选条件
	 * @param Integer $pageSize 默认10
     * Date: 2020/6/13
     * @return array
     */
    public function listRefundTasks(array $conditions, Integer $pageSize) : array;

    /**
     * description:新建退税单 获取底部产品列表
     * author: fuyunnan
     * @param array $conditions 请求参数
     * @param integer $pageSize 请求参数
     * Date: 2020/6/13
     * @return array
     */
    public function listRefundProducts(array $conditions = [], Integer $pageSize = 10 ) :array;


     /**
      * description:删除退税任务
      * author: fuyunnan
      * @param int $id 计划任务id
      * Date: 2020/6/13
      * @return bool
      */
    public function delete($id) :bool;


}
