<?php
namespace Meibuyu\Micro\Aspect;

use Hyperf\Di\Annotation\Aspect;
use Hyperf\Di\Aop\AbstractAspect;
use Hyperf\Di\Aop\ProceedingJoinPoint;
use Hyperf\HttpServer\Contract\RequestInterface;
use Meibuyu\Micro\Annotation\LogTrace;
use Meibuyu\Micro\Handler\LogTrace\LogTraceHandler;

/**
 * @Aspect(
 *   annotations={
 *      LogTrace::class
 *   }
 * )
 */
class LogTraceAspect extends AbstractAspect
{

    /**
     * 优先级
     * @var int
     */
    public $priority = 999;

    public function process(ProceedingJoinPoint $proceedingJoinPoint)
    {
        $originParams = [
            'called_params'=>$proceedingJoinPoint->getArguments(),
            'http_params'=>make(RequestInterface::class)->all()
        ];
        LogTraceHandler::createLogTrace(
            $proceedingJoinPoint->className.'@'.$proceedingJoinPoint->methodName,
            $originParams
        );
        $result =  $proceedingJoinPoint->process();
        LogTraceHandler::recordProcess('返回结果：'.json_encode($result));

        return $result;
    }
}