<?php
/**
 * Created by PhpStorm.
 * User: zero
 * Date: 2020/5/26
 * Time: 15:17
 */

namespace Meibuyu\Micro\Service\Interfaces\User;

interface AuthenticationServiceInterface
{

    /**
     * 获取对应用户能够看到的菜单
     * @param string $applicationName
     * @param integer $userId
     * @return array
     */
    public function getMenus($applicationName, $userId): array;


    /**
     * 获取对应用户的菜单权限
     * @param string $applicationName 应用名称
     * @param integer $userId 用户 ID
     * @return array
     */
    public function getButtons($applicationName, $userId):array;


    /**
     * 获取对应路由的接口权限结果
     * @param $route string 路由名字
     * @param $applicationName string 应用名字
     * @param $method string  请求方法
     * @param $userId integer  用户 ID
     * @return bool
     */
    public function authByRouter($applicationName, $route, $method, $userId):  bool;

}
