<?php


namespace Meibuyu\Micro\Handler\LogTrace;

use Meibuyu\Micro\Handler\RedisQueueBatchHandler;
use Meibuyu\Micro\Model\LogTrace;


class LogTraceQueue extends RedisQueueBatchHandler
{

    protected function specifyQueueName()
    {
        $this->queue_name = env('APP_NAME').':LogTraceQueue';
    }

    /**
     * 具体批处理逻辑
     * @param $dataArr
     */
    function batchDeal($dataArr)
    {
        $updateArr = [];
        $updateMarkComplete = [];

        foreach ($dataArr as $arr){

            if(isset($arr['is_completed'])&&$arr['is_completed']==YES){
                $updateMarkComplete[]= $arr['request_id'] ;continue;
            }
            $updateArr[$arr['request_id']]['request_id'] = $arr['request_id'];

            $process_info = isset($updateArr[$arr['request_id']]['process_info'])?
                             $updateArr[$arr['request_id']]['process_info']:'';

            $updateArr[$arr['request_id']]['process_info'] = $process_info.$arr['process_info'];

        }

        //执行前先查一下 原先有的记录 避免被覆盖
        $originLogs = LogTrace::whereIn('request_id',array_column($dataArr,'request_id'))
            ->pluck('process_info','request_id')->toArray();
        //追加到原记录之后
        $updateArr =  array_map(function ($item)use($originLogs){

            if(!isset($originLogs[$item['request_id']])) return $item;

            if(empty($originLogs[$item['request_id']])) return $item;

            $item['process_info'] = $originLogs[$item['request_id']].$item['process_info'];

            return $item;
        },$updateArr);

        //批量更新
        if(!empty($updateMarkComplete)){
            LogTrace::whereIn('request_id',$updateMarkComplete)->update(['is_completed'=>YES]);
        }
        if(!empty($updateArr)){
            LogTrace::getModel()->batchUpdateByField(array_values($updateArr),'request_id');
        }
    }


}