<?php

namespace Meibuyu\Micro\CenterConfig\Nacos;


class Config
{
    private $baseUri = 'http://127.0.0.1:8848';

    private $guzzleConfig = [
        'headers' => [
            'charset' => 'UTF-8',
        ],
        'http_errors' => false,
    ];

    private $username;

    private $password;

    public function __construct(array $config)
    {
        $baseUri = sprintf('http://%s:%d', $config['NACOS_HOST'] ?? '192.168.1.27', $config['NACOS_PORT'] ?? 8848);
        $this->setBaseUri($baseUri);

        $userName = $config['NACOS_USER'] ?? 'nacos';
        $pass = $config['NACOS_PASS'] ?? 'nacos';

        $this->setUsername($userName);

        $this->setPassword($pass);

    }


    /**
     * @return string
     */
    public function getBaseUri(): string
    {
        return $this->baseUri;
    }

    /**
     * @param string $baseUri
     */
    public function setBaseUri(string $baseUri): void
    {
        $this->baseUri = $baseUri;
    }

    /**
     * @return array
     */
    public function getGuzzleConfig(): array
    {
        return $this->guzzleConfig;
    }

    /**
     * @param array $guzzleConfig
     */
    public function setGuzzleConfig(array $guzzleConfig): void
    {
        $this->guzzleConfig = $guzzleConfig;
    }

    /**
     * @return mixed
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param mixed $username
     */
    public function setUsername($username): void
    {
        $this->username = $username;
    }

    /**
     * @return mixed
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param mixed $password
     */
    public function setPassword($password): void
    {
        $this->password = $password;
    }


}