<?php


namespace Meibuyu\Micro\Handler;
use Hyperf\Redis\Redis;

abstract class RedisQueueBatchHandler
{
    /**
     * 重试次数
     */
    protected $retry=0;

    protected $queue_name;

    /**
     * @var Redis
     */
    protected $redis;

    const MAX_RETRY_TIMES = 3;

   // const BATCH_DEAL_NUM = 36;

    protected $batch_deal_num = 8;

    const ERROR_RETRY_CODE = 9000;

    /**
     * RedisQueueBatchHandler constructor.
     */
    public function __construct()
    {
        $this->queue_name = $this->specifyQueueName();
        $this->redis = $this->specifyRedisServer();
    }


    /**
     * @param $data
     * @param $specifyQueue
     */
    public function addToQueue($data,$specifyQueue='')
    {
        $this->redis->rPush($specifyQueue?:$this->queue_name,json_encode($data));
    }

    /**
     * 将执行失败的数据重回队列 尾部 不影响其他数据执行
     * @param $arr
     */
    protected function backToQueue($arr)
    {
        $this->redis->rPush($this->queue_name,...$arr);
    }

    //批处理具体逻辑
    abstract protected function batchDeal($data);
    abstract protected function specifyQueueName();
    abstract protected function specifyRedisServer() : Redis;


    public function consume()
    {

        while (true){
            //有数据则放回 否则延迟20s后返回空数组，同时可保持连接活跃
            //执行过程 如果redis服务异常，调用io操作时异常退出，框架重新拉起该进程
            $exist = $this->redis->blPop($this->queue_name,30);
            if(empty($exist)) continue ;
            $this->redis->lPush($this->queue_name,$exist[1]);

            //每次从列表取100
            $arr = $this->redis->lRange($this->queue_name,0,$this->batch_deal_num-1);

            //数据格式化
            $formatArr = array_map(function ($item){
                return json_decode($item,true);
            },$arr);
            //取完 从队列删掉
            $this->redis->lTrim($this->queue_name,count($arr),-1);

            if(!$this->tryTreeTimesBatchDeal($formatArr)){
                 $this->backToQueue($arr);
            }
        }

    }

    /**
     * 重试三次批处理 每次延迟6秒执行
     * @param $formatArr
     * @param int $retry
     * @author Liu lu
     * date 2023-05-10
     */
    private function tryTreeTimesBatchDeal($formatArr,$retry=0)
    {
        if($retry>=3) return  false;
        try {
            //具体批处理逻辑
            $this->batchDeal($formatArr);
            return true;
        }catch (\Throwable $exception){
            $retry++;
            sleep(6);
            $this->errorWriteToFile($formatArr,$exception);
            return $this->tryTreeTimesBatchDeal($formatArr,$retry);
        }
    }

    /**
     * @param $data
     * @param \Throwable $exception
     */
    private function errorWriteToFile($data, \Throwable $exception)
    {
        put_log(
            json_encode($data)."\n".
            $exception->getMessage()."\n".
            $exception->getFile().' line:'.
            $exception->getLine()."\n".
            $exception->getTraceAsString()

            ,'RedisQueue/'.$this->queue_name.'/'.today()
        );
    }


}