<?php
/**
 * Created by PhpStorm.
 * User: Zero
 * Date: 2020/5/6
 * Time: 8:54
 */

namespace Meibuyu\Micro\Listener;

use Hyperf\Consul\Exception\ServerException;
use Hyperf\ServiceGovernance\Listener\RegisterServiceListener as BaseRegisterServiceListener;

class RegisterServiceListener extends BaseRegisterServiceListener
{

    protected function getServers(): array
    {
        $result = [];
        $servers = $this->config->get('server.servers', []);
        foreach ($servers as $server) {
            if (!isset($server['name'], $server['host'], $server['port'])) {
                continue;
            }
            if (!$server['name']) {
                throw new \InvalidArgumentException('Invalid server name');
            }
            /**
             * 若在docker中运行,会获取到docker环境中的ip
             * 这里对配置文件中local_ip判断,如果有,直接使用
             */
            $host = isset($server['local_ip']) ? $server['local_ip'] : $server['host'];
            if (in_array($host, ['0.0.0.0', 'localhost'])) {
                $host = $this->getRealInternalIp();
            }
            if (!filter_var($host, FILTER_VALIDATE_IP)) {
                throw new \InvalidArgumentException(sprintf('Invalid host %s', $host));
            }
            $port = $server['port'];
            if (!is_numeric($port) || ($port < 0 || $port > 65535)) {
                throw new \InvalidArgumentException(sprintf('Invalid port %s', $port));
            }
            $port = (int)$port;
            $result[$server['name']] = [$host, $port];
        }
        return $result;
    }


    protected function getRealInternalIp()
    {
        if (method_exists(self::class, 'getInternalIp')) {
            return $this->getInternalIp();
        }

        $ips = swoole_get_local_ip();
        if (is_array($ips) && ! empty($ips)) {
            return current($ips);
        }
        /** @var mixed|string $ip */
        $ip = gethostbyname(gethostname());
        if (is_string($ip)) {
            return $ip;
        }
        throw new \RuntimeException('Can not get the internal IP.');
    }
    public function process(object $event)
    {
        $this->registeredServices = [];
        $continue = true;
        $env = $this->config->get('app_env');
        while ($continue) {
            try {
                $services = $this->serviceManager->all();
                $servers = $this->getServers();
                foreach ($services as $serviceName => $serviceProtocols) {
                    foreach ($serviceProtocols as $paths) {
                        foreach ($paths as $path => $service) {
                            if (! isset($service['publishTo'], $service['server']) || $env == 'dev-mf') {
                                continue;
                            }
                            [$address, $port] = $servers[$service['server']];
                            switch ($service['publishTo']) {
                                case 'consul':
                                    $this->publishToConsul($address, (int) $port, $service, $serviceName, $path);
                                    break;
                            }
                        }
                    }
                }
                $continue = false;
            } catch (ServerException $throwable) {
                if (strpos($throwable->getMessage(), 'Connection failed') !== false) {
                    $this->logger->warning('Cannot register service, connection of service center failed, re-register after 10 seconds.');
                    sleep(10);
                } else {
                    throw $throwable;
                }
            }
        }
    }

}