<?php
/**
 * Created by PhpStorm.
 * User: 姜克保
 * Date: 2020/5/20
 * Time: 15:48
 */

namespace Meibuyu\Micro\Service\Interfaces;

interface DispatchPlanServiceInterface
{
    /**
     * 根据发货计划id获取发货计划信息
     * @param int $id 计划任务id
     * @return array
     */
    public function getDispatchPlanById(int $id): array;

    /**
     *获取发货任务列表
     * @return array
     */
    public function listDispatchPlans(array $conditions, bool $isPage = true): array;


    /**
     * description:获取退税任务列表
     * author: fuyunnan
     * @param array $conditions
     * Date: 2020/6/13
     * @return array
     */
    public function listRefundTasks(array $conditions) : array;



    /**
     * description:新建退税单 获取底部产品列表
     * author: fuyunnan
     * @param array $request 请求参数
     * Date: 2020/6/13
     * @return array
     */
    public function listRefundProducts(array $request) :array;


     /**
      * description:删除退税任务
      * author: fuyunnan
      * @param int $id 主键
      * Date: 2020/6/13
      * @return int
      */
    public function delete($id) :int;

}
