<?php
/**
 * Created by PhpStorm.
 * User: Zero
 * Date: 2020/8/19
 * Time: 9:06
 */

namespace Meibuyu\Micro\Tools;

//use GuzzleHttp\Client;
//use Psr\Http\Message\ResponseInterface;

/**
 * json格式请求(非协程)
 * Class HttpRequestJson
 * @package Meibuyu\Micro\Tools
 */
class HttpRequestJson
{

    protected static function prepareRequest($headers, $data = [])
    {
        $data = json_encode($data);
        if (!empty($data)) {
            $headers['Content-type'] = 'application/json';
            $headers['Content-Length'] = strlen($data);
        }
        return [$headers, $data];
    }

//    /**
//     * get请求
//     * @param $url
//     * @param array $httpHeaders
//     * @return ResponseInterface
//     */
//    public static function get($url, $httpHeaders = [])
//    {
//        $client = new Client(['timeout' => 30]);
//        return $client->get($url, ['headers' => $httpHeaders]);
//    }
//
//    /**
//     * post请求
//     * @param $url
//     * @param $data
//     * @param array $httpHeaders
//     * @return ResponseInterface
//     */
//    public static function post($url, $data, $httpHeaders = [])
//    {
//        $client = new Client(['timeout' => 30]);
//        return $client->post($url, ['headers' => $httpHeaders, 'json' => $data]);
//    }
//
//    /**
//     * put请求
//     * @param $url
//     * @param $data
//     * @param array $httpHeaders
//     * @return ResponseInterface
//     */
//    public static function put($url, $data, $httpHeaders = [])
//    {
//        $client = new Client(['timeout' => 30]);
//        return $client->put($url, ['headers' => $httpHeaders, 'json' => $data]);
//    }
//
//    /**
//     * delete请求
//     * @param $url
//     * @param array $httpHeaders
//     * @return ResponseInterface
//     */
//    public static function delete($url, $httpHeaders = [])
//    {
//        $client = new Client(['timeout' => 30]);
//        return $client->delete($url, ['headers' => $httpHeaders]);
//    }

    /**
     * get请求
     * @param $url
     * @param array $headers
     * @return array
     */
    public static function get($url, $headers = [])
    {
        return CurlRequest::get($url, $headers);
    }

    /**
     * post请求
     * @param $url
     * @param $data
     * @param array $headers
     * @return array
     */
    public static function post($url, $data, $headers = [])
    {
        [$headers, $data] = self::prepareRequest($headers, $data);
        return CurlRequest::post($url, $data, $headers);
    }

    /**
     * put请求
     * @param $url
     * @param $data
     * @param array $headers
     * @return array
     */
    public static function put($url, $data, $headers = [])
    {
        [$headers, $data] = self::prepareRequest($headers, $data);
        return CurlRequest::put($url, $data, $headers);
    }

    /**
     * delete请求
     * @param $url
     * @param array $headers
     * @return array
     */
    public static function delete($url, $headers = [])
    {
        return CurlRequest::delete($url, $headers);
    }

}
