<?php
/**
 * Created by PhpStorm.
 * User: 王源
 * Date: 2020/3/16
 * Time: 15:07
 */

namespace Meibuyu\Micro\Service\Interfaces;

interface StoreServiceInterface
{

    /**
     * 通过id列表获取仓库名称
     * @param array $idList 仓库id的列表, 默认去重
     * @param array $columns 仓库表的字段，默认显示全部
     * @return array 默认keyBy('id')
     */
    public function getByIdList(array $idList, array $columns = ['*']): array;


    /**
     * description:创建入库单
     * author: fuyunnan
     * @param array $data 需要入库的数组 格式请参考yapi 入库添加
     * @return array
     * @throws
     * Date: 2020/7/6
     */
    public function createWarehousing(array $data): array;


    /**
     * description:生产单结束获取统计单号值
     * author: fuyunnan
     * @param string $sourceNo 生产单号
     * @return array
     * @throws
     * Date: 2020/7/10
     */
    public function CntSourceNoOrder($sourceNo): array;


    /**
     * description:通过来源单号获取产品列表
     * author: fuyunnan
     * @param string $sourceNo 生产单号
     * @return array
     * @throws
     * Date: 2020/7/10
     */
    public function listSourceNoProduct($sourceNo): array;


    /**
     * description:根据来源单号，获取分组后的入库单
     * author: fuyunnan
     * @param array $sourceNoList 单号列表
     * @param array $where 刷选列表
     * @return array
     * @throws
     * Date: 2020/7/11
     */
    public function listGroupOrder($sourceNoList, $where = []): array;


    /**
     * description:通过入库单id数组获取产品列表
     * author: fuyunnan
     * @param array $ids 入库单ids 数组
     * @return array
     * @throws
     * Date: 2020/7/10
     */
    public function listIdsProduct($ids): array;


    /**
     * description:修改二次质检状态
     * author: fuyunnan
     * @param int $orderId 入库单id
     * @param array $update 修改数组
     * @return int
     * @throws
     * Date: 2020/7/14
     */
    public function updateQualityStatus($orderId, $update): int;


    /**
     * description:修改二次质检状态
     * author: fuyunnan
     * @param array $orderIds 入库单id数组
     * @param array $update 修改数组
     * @return int
     * @throws
     * Date: 2020/7/14
     */
    public function updateListQualityStatus($orderIds, $update): int;


    /**
     * description:通过产品id数组获取库存列表
     * author: fuyunnan
     * @param array $ids 产品ids 数组
     * @param int $wareId 仓库id
     * @return array
     * @throws
     * Date: 2020/7/27
     */
    public function getListStock($ids, $wareId = 0): array;


    /**
     * description:检查是否有库存，有就返回库存数量（有记录）
     * author: fuyunnan
     * @param array $ids 仓库产品的id数组
     * @return array
     * @throws
     * Date: 2020/7/31
     */
    public function checkStock($ids):array;

}