<?php
/**
 * Created by PhpStorm.
 * User: Zero
 * Date: 2020/10/12
 * Time: 9:39
 */

namespace Meibuyu\Micro\Service\Interfaces\Product;

interface ShopifyServiceInterface
{

    /**
     * 拉取一个shopify订单数据
     * @param $orderId
     * @param $shopifySiteId
     * @return array
     * @throws \Exception
     */
    public function pullOrder($orderId, $shopifySiteId): array;

    /**
     * 通过id列表获取shopify站点数组
     * @param array $ids shopify站点id数组,默认去重
     * @param array $columns shopify站点表字段,默认['name', 'prefix', 'team_id', 'site_id', 'language_id', 'url', 'currency_id']
     * @return array 默认keyBy('id')
     * @author Zero
     */
    public function getShopifySitesByIds(array $ids, $columns = ['name', 'prefix', 'team_id', 'site_id', 'language_id', 'url', 'currency_id']): array;

}
