<?php
/**
 * 团队产品
 *
 * @author zhangdongying
 * @date   2023-05-26
 */
declare(strict_types=1);

namespace Meibuyu\Micro\Service\Interfaces\Product;

interface TeamProductServiceInterface
{
    /**
     * 获取分销产品列表
     *
     * @param array $teamIds 团队ID数组
     * @param array $childProductIds 仓库子产品SKU数组
     * @return array ['id', 'team_id', 'product_id', 'child_product_id', 'own_team_id', 'own_warehouse_id']
     */
    public function getDistributionProductListByTeamIds(array $teamIds, array $childProductIds = []): array;
}