<?php

namespace Meibuyu\Micro\CenterConfig;

use Meibuyu\Micro\CenterConfig\Nacos\NacosDriver;
use Psr\Container\ContainerInterface;

class CenterConfig
{
    private $env = [];

    private $alias = [
        'nacos' => NacosDriver::class,
    ];


    public function load()
    {
        $this->loadEnv();

        //默认nacos驱动
        $dirver = $this->env['CONFIG_CENTER_DRIVER'] ?? 'nacos';

        $isEnable = $this->env['CONFIG_CENTER'] ?? false;
        $isEnable = $isEnable == 'true' ? true : false;
        if($isEnable) {
            $instances = self::getDriverInstance($dirver);
            $instances->fetchConfig($this->env);
        }
    }

    /**
     * Notes: 获取驱动连接实例
     * User: carlos
     * DateTime: 2022/9/9 9:21
     */
    public function getDriverInstance($dirver)
    {
        $className = $this->alias[$dirver];
        return new $className();
    }

    /**
     * Notes: 是否开启配置中心
     * User: carlos
     * DateTime: 2022/9/8 18:27
     * @return bool
     */
    public function isEnable() :bool
    {
        $flag = false;
        $key = 'CONFIG_CENTER';
        if(array_key_exists($key, $this->env) && $this->env[$key]) {
            $flag = true;
        }

        return $flag;
    }

    /**
     * Notes: 加载env文件
     * User: carlos
     * DateTime: 2022/9/8 18:12
     */
    public function loadEnv()
    {
        $envFileName = BASE_PATH.'/.env';
        $handle = fopen($envFileName, 'r');
        if (!$handle) {
            echo '文件打开失败！';
        }
        while (false !== ($char = fgets($handle,1024))) {
            if(strlen(trim($char)) > 0 && $char[0] != '#') {
                try {
                    $res = explode('=', $char);
                    $this->env[$res[0]] = $res[1];
                    $this->setEnv($res[0], $res[1]);
                }catch (\Exception $e) {

                }
            }
        }
        fclose($handle);
    }

    /**
     * @return array
     */
    public function getEnv(): array
    {
        return $this->env;
    }

    /**
     * @param array $env
     */
    public function setEnv($key, $value): void
    {
        $this->env[trim($key)] = trim($value);
    }



}