<?php
/**
 * Created by PhpStorm.
 * User: Zero
 * Date: 2020/7/3
 * Time: 14:27
 */

namespace Meibuyu\Micro\Handler;

use Hyperf\Contract\ConfigInterface;
use Hyperf\Di\Annotation\Inject;
use Meibuyu\Micro\Exceptions\HttpResponseException;
use Meibuyu\Micro\Model\Auth;
use Meibuyu\Micro\Service\Interfaces\MessageServiceInterface;

class MessageHandler
{

    /**
     * @Inject()
     * @var MessageServiceInterface
     */
    private $messageService;

    /**
     * @Inject
     * @var ConfigInterface
     */
    protected $config;

    /**
     * 发送模板消息
     * @param $receiverIds
     * @param $templateId
     * @param array $replace
     * @throws HttpResponseException
     */
    public function sendTemp($receiverIds, $templateId, $replace = [])
    {
        $application = $this->config->get('app_name');
        if (!$application) {
            throw new HttpResponseException("请设置应用名app_name");
        }
        $receiverIds = is_array($receiverIds) ? $receiverIds : [$receiverIds];
        $sendUserId = Auth::id();
        $this->messageService->send($receiverIds, $application, $templateId, $sendUserId, $replace);
    }

}