<?php

namespace Meibuyu\Micro\Tools;
use Chumper\Zipper\Zipper;

/**
 * 打包器
 * Class PackFiler
 */
class Unpacker
{
    //文件列表 一位数组
    public $fileList;
    //保存路径
    public $path;
    //文件名
    public $fileName;

    public function __construct(array $fileList, $path, $fileName)
    {
        $this->fileList = $fileList;
        $this->path = $path;
        $this->fileName = $fileName;
    }

    /**
     * 打包
     * @return string
     * @throws \Exception
     */
    public function unpack()
    {
        $zipper = new Zipper();
        $filePath = $this->path.'/'.$this->fileName.'.zip';
        $zipper->make($filePath)->add($this->fileList);
        $zipper->close();
        return $filePath;
    }
}