<?php

namespace Meibuyu\Rpc\Service\Interfaces\FeiShu;

interface FeiShuMessageServiceInterface
{

    /**
     * Notes: 批量发送消息
     * User: carlos
     * DateTime: 2021/12/15 17:31
     * @param array $userIds
     * @param string $template
     * @param array $data
     * @return mixed
     */
    public function batchSendMsg(array $userIds, string $template, array $data);


    /**
     * Notes: 发送markdown消息
     * User: carlos
     * DateTime: 2021/12/29 10:28
     * @param array $data ['标题', '内容']
     * @param string $application 应用名称
     * @param array $receiveUserId 接收人
     * @param int $sendUserId 发送人
     * @param string $template 模板名称
     * @return string
     */
    public function sendMessage(array $data, string $application, array $receiveUserId, int $sendUserId = 0, string $template = '');

}
