<?php
/**
 * 全局操作日志RPC接口
 *
 * @author zhangdongying
 * @date   2023-03-21
 */
declare(strict_types=1);

namespace Meibuyu\Rpc\Service\Interfaces\App;

interface GlobalOperateLogServiceInterface
{
    /**
     * 获取全局操作日志列表
     *
     * @param array $operateTypes 操作类型数组，例如：["产品管理-产品列表-更新产品","产品管理-产品列表-创建产品"]
     * @param string $recordId 关联数据ID，例如：18186
     * @param array $columns 字段数组，例如：['id', 'operator_id', 'operator_name', 'remark', 'created_at']，参考表operate_logs
     * @param array $orderBys 排序，例如：[["created_at", "desc"], ["id", "desc"]]
     * @return array
     */
    public function getList(
        array $operateTypes,
        string $recordId,
        array $columns = ['id', 'operator_id', 'operator_name', 'remark', 'created_at'],
        array $orderBys = [['id', 'desc']]
    ): array;

    /**
     * 获取全局操作日志分页列表
     *
     * @param array $operateTypes 操作类型数组，例如：["产品管理-产品列表-更新产品","产品管理-产品列表-创建产品"]
     * @param string $recordId 关联数据ID，例如：18186
     * @param int $page 页码
     * @param int $pageSize 每页数量
     * @param array $columns 字段数组，例如：['id', 'operator_id', 'operator_name', 'remark', 'created_at']，参考表operate_logs
     * @param array $orderBys 排序，例如：[["created_at", "desc"], ["id", "desc"]]
     * @return array
     */
    public function getPageList(
        array $operateTypes,
        string $recordId,
        int $page,
        int $pageSize,
        array $columns = ['id', 'operator_id', 'operator_name', 'remark', 'created_at'],
        array $orderBys = [['id', 'desc']]
    ): array;
}