<?php


namespace Meibuyu\Rpc\Service\Interfaces\OutsideFactory;


use App\Services\Production\ProductionExceptionService;

interface FactoryServiceInterface
{


    /**
     * 打印工艺单信息 返回导出地址
     * @param $craftInfo
     * @return String
     */
    public function productCraftPrint($craftInfo) ;

    /**
     * 打印发货单
     * @param $deliveryNo 发货单号
     * @return mixed
     */
    public function downDeliveryRecord($deliveryNo);
    /**
     * 获取对应的工厂信息
     * @param array $factoryIds
     * @param array|string[] $columns
     * @return mixed
     */
    public function getFactories(array $factoryIds = [], array $columns = ['*']);

    /**
     * 根据筛选条件获取对应的工厂信息
     * @param array $filters 筛选条件
     * @param array|string[] $columns 查询字段
     * @return mixed
     */
    public function getFactoriesByFilters(array $filters = [], array $columns = ['*']);

    /**
     * 生产端留言投递到工厂端订单表
     * @param array $production_no  生产单号
     * @return mixed
     */
    public function toProductOrderMessage(array $post);

    /**
     *  工厂列表
     * @param string  $id 工厂id
     * @return array  $list
     */
    public function factoryList();

    /**
     *  子工厂列表
     * @return array  $list
     */
    public function  childFactoryList($id);


    /**
     *  工厂树状列表
     * @return array  $list
     */
    public function treeFactoryList();


    /**
     * 获取分派详情通过来源订单号
     * @param $originalProductionNos
     * @return array|mixed
     * @author Liu lu
     * date 2022-09-19
     */
    public function getApportionInfoListByNos($originalProductionNos);


    /**
     * Notes: 分派订单取消
     * User: carlos
     * @param string $type cancel|delete
     * DateTime: 2022/9/21 14:24
     */
    public function cancelOrder($orderNo, $type = 'cancel');

    /**
     * Notes: 获取订单信息
     * User: carlos
     * DateTime: 2022/9/22 16:21
     * @param $orderNo
     */
    public function getProductionOrder($orderNo, $columns =['*'],$with=[]);



    /**
     * 获取供应链获取工厂端生产对账单
     * @param $searchConditions 搜索条件
     * @param bool $isExport 是否导出
     * @return array|\Hyperf\Contract\LengthAwarePaginatorInterface|mixed
     * @author Liu lu
     * date 2022-09-27
     */
    public function getProductionAccountStatement($searchConditions,$isExport=false);


    /**
     * 供应链获取工厂端生产对账单数量
     * @param $searchConditions 搜索条件
     * @return int
     * @author Liu lu
     */
    public function getProductionAccountCount($searchConditions);


    /**
     * Notes: 生产订单完结
     * User: carlos
     * DateTime: 2022/9/29 9:52
     */
    public function finishProductionOrder($orderSn);

    /**
     * Notes: 确认收货
     * User: carlos
     * DateTime: 2022/11/21 14:14
     */
    public function confirmDelivery($params);


    /**
     * Notes: 通过最小订单号批量获取原始订单号
     * @param $orderNoArr
     * @param string[] $columns
     * @param $with[] $with
     * @return array
     */
    public function getProductionListByOrderNo($orderNoArr, $columns =['*'],$with=[]);

    /**
     * Notes: 少货处理
     * User: carlos
     * DateTime: 2022/11/21 19:03
     */
    public function shortageProcess($delivery_no, $shortageProduct);


    /**
     * Notes: 退回返修
     * User: carlos
     * DateTime: 2022/11/23 11:43
     * @param $params
     */
    public function repairReturn($delivery_no, $repairProducts);

    /**
     * Notes: 处理到仓返修异常
     * User: carlos
     * DateTime: 2022/11/27 9:23
     */
    public function processWarehouseRepair($params);



    /**
     * 推送供应商数据到工厂系统
     * @author Liu lu
     * @param $post demo
        {
        `name` '工厂名称',
        `abbreviation`  '简称',
        `code`  '代码',
        `manager_id`  '管理者id',
        `phone` '电话',
        `address`  '地址',
        `score`  '平均评分',
        `creator_id` '创建人id',
        `type_id`  '类型',
        `remark` '备注',
        `can_invoice`  '能否开发票，默认为 0，可以开票为 1',
        `status`  '状态 1:正常 0:停用',
        `is_transfer`  '能否转派 1:能 0:不能'
        }
     * @return int 主键id
     */
    public function pushSupplyDataToFactory($post);

    /**
     * Notes: 发货状态
     * User: carlos
     * DateTime: 2022/12/5 10:08
     */
    public function updateDeliveryStatus($params);


    /***
     * 账单标记结算
     * 发货表与返修出库表标记已结算
     * @param $params
     * @author Liu lu
     * date 2022-12-19
     */
    public function billMarkSettled($params);


    /**
     * 生产通知单下载
     * @param $originProductionNo
     * @author Liu lu
     * date 2023-02-02
     */
    public function productionNoticeDownload($originProductionNo);

    /**
     * 获取工艺单地址
     * @param $deliveryNo 发货单号
     * @author Jack
     * date 2023-02-17
     */
    public function getCraftDocAddressByDeliveryNo($deliveryNo);


    /**
     * 通过名称获取工厂信息
     * @param $params
     * @return mixed
     */
    public function getFactoryInfoByNames($params);


    /**
     * 通过供应链生产单号批量获取工厂端分派生产单号数据
     * @param array $productionNo
     * @param string[] $columns
     * @param array $with
     * @return array|mixed|null
     * @author Liu lu
     * date 2023-04-26
     */
    public function getApportionListByProductionNo(array $productionNo,$columns=['*'],$with=[]);


    /**
     * 判断是否为工厂的sku
     * @param $params
     */
    public function isFactoryWithSku($params);


    /**
     * 按sku或按工厂
     * @param $params
     * @return array
     */
    public function getFactoryStockList($params);



    /**
     * 通过sku查询子sku可用库存和生产中库存
     * @param $skuList
     * @return array
     */
    public function UsefulStockAndProducingStockBySku($skuList);



    /**
     * 供应链工厂自主备货看板
     */
    public function selfFactoryStock();


    /**
     * 通过sku查询主sku可用库存和生产中库存
     * @param $skuList
     * @return array
     */
    public function getSkuStockBySku($skuList);

    /**
     * Notes: 锁定库存
     * User: carlos
     * DateTime: 2023/5/17 14:18
     * @param $params
     * @return bool
     */
    public function lockStockCount($params);

    /**
     * Notes: 锁定工厂库存
     * User: carlos
     * DateTime: 2023/5/17 14:19
     */
    public function lockFactoryStockCount($params);

    /**
     * Notes: 解锁库存
     * User: carlos
     * DateTime: 2023/5/17 15:35
     * @param $params
     */
    public function unlockStockCount($params);

    /**
     * Notes: 更新清点数量
     * User: carlos
     * DateTime: 2023/6/12 14:42
     * @param $params
     * @return mixed
     */
    public function updateCheckDeliveryCount($params);

    /**
     * Notes: 异常销毁工厂更新
     * User: carlos
     * DateTime: 2023/6/15 10:02
     * @param $params
     */
    public function updateExceptionDestroy($params);


    /**
     * 查询是否为分派订单信息,返回跟单员、订单类型、合作方式
     * @param $orderNoArr
     * @param int $type  //type = 1生产订单、 type = 2服装对账单结算
     * @return array
     */
    public function getProductionApportionInfo($orderNoArr,$type = 1);



    /**
     * 获取二级工厂分派员
     * @param $deliverNos
     */
    public function getApportionFactory($deliverNos);


    /**
     * 大货生产接单后工艺信息确认提交
     * @param $productionNo
     * @param $auth 操作人数组
     */
    public function craftConfirmPush($productionNo,$auth);


    /**
     * 获取生产sku的指定工厂数组
     * @param $skuArr
     * @return mixed
     * @author Liu lu
     * date 2024-04-02
     */
    public function getFactoriesBySkuList($skuArr) ;


    /**
     * @param array $paperAccountInfo 批量要修改的纸质账单发货单号信息
     * @example  [
     *             ['paper_account_no'=>'纸质账单号1','delivery_no'=>'发货单号1'] ,
     *             ['paper_account_no'=>'纸质账单号2','delivery_no'=>'发货单号2'] ,
     *           ]
     * @return array 返回对应发货单号的是否结算完成信息
     * @example [
     *              '发货单号1'=>true ,  //true 代表提交成功
     *              '发货单号2'=>'发货单号已结算，请勿重复提交'
     *          ]
     * @author Liu lu
     * date 2024-04-16
     */
    public function addPaperAccountNo(array $paperAccountInfo):array ;

    /**
     * 获取发货批次列表 
     *
     * @param string $originalProductionNo 生产订单号
     * @param array $columns 列名数组
     * @param array $relations 关联数组，['delivery_products', 'production_order']
     * @return array
     */
    public function getDeliveryRecordListByOriginalProductionNo(string $originalProductionNo, array $columns = ['*'], array $relations = []): array;

    /**
     * 获取发货批次列表
     *
     * @param array $originalProductionNos 生产订单号数组
     * @param array $columns 列名数组
     * @param array $relations 关联数组，['delivery_products', 'production_order']
     * @return array
     */
    public function getDeliveryRecordListByOriginalProductionNos(array $originalProductionNos, array $columns = ['*'], array $relations = []): array;
}