<?php


namespace Meibuyu\Rpc\Service\Interfaces\DatacenterNew;


interface RateServiceInterface
{



    /**
     * 根据币种代码currency_code获取最新 对应的汇率
     * @param array $codes currency_code币种代码数组
     * @param array $month month月份数组
     * @return array
     * @author Zero
     */
    public function getRateByCurrencyCode(array $codes,  array $month = []);


    /**
     * 根据币种代码currency_code获取最新 对应的汇率列表
     * @param array $codes currency_code币种代码数组
     * @param array $month month月份数组
     * @return array
     * @author Zero
     */
    public function getRateList(array $codes=[],  array $month = []);


    /**
     * 获取对应品名对应的毛利率
     * @param $productNameIds array 品名 ID
     * @param $year string 年份
     * @param string $month 月份，默认是当月
     * @param bool $keyed 返回是否要按照 porudctNameIds 作为 key
     * @return array
     */
    public function getGrossRateByProductNameIds($productNameIds, $year, $month = '', $keyed = true): array;


    /***
     * 根据 currency code 和策略获取对应月份或者日期的汇率。
     * @param string $currencyCode
     * @param string $month
     * @param string $day
     * @return mixed
     */
    function getRateByCurrencyCodeAndSetting(string $currencyCode, string $month = '', string $day = '');
}