<?php

/**
 * 新供应商rpc
 */

namespace Meibuyu\Rpc\Service\Interfaces\Supply;


interface SupplyServiceInterface
{


    /**
     * 获取
     * @param $id
     * @param $column
     * @param $sourceType 工厂系统 | 采购系统
     * @return mixed
     * @author Liu lu
     * date 2022-12-03
     */
    public function getSupplyByOldId($id,$column=['*'],$sourceType='工厂系统');


    /**
     * 获取供应商
     * @param array $ids
     * @param array $column
     * @param string $sourceType
     * @return mixed
     * @author Liu lu
     * date 2022-12-19
     */
    public function getSupplyListByRelatedIds(array $ids, $column = ['*'],$sourceType='工厂系统');



    /**
     * 通过名称批量获取供应商信息
     * @param $names 名称数组
     * @param string[] $column
     * @param string $searchType 搜索类型如 'material_supply' => 搜索原料供应商
     * @author Liu lu
     * date 2023-05-08
     */
    public function  getSupplyListByName($names,$column = ['*'],$searchType='');


    /**
     *
     * @param $factory_id
     * @return mixed
     */
    public function getSupplierInvoiceInformation($factory_id);


    /**
     * 获取工厂供应商发票税率、采购税率
     * @param $factoryIds
     */
    public function getSupplierInfo($factoryIds);


    public function getFactoryAssessmentResult($params);


    public function getFactoryAssessmentList($params);


    /**
     * 获取考核结果年份
     * @param $params
     * @return array
     */
    public function getFactoryYearMonth($params);

    /**
     * 获取供应商列表（通过供应商代码）
     *
     * @param array $codes 供应商代码数组
     * @param array $columns 字段数组
     * @return array keyBy('code')
     */
    public function getSupplierListByCodes(array $codes, array $columns = ['*']): array;

    /**
     * 获取启用的供应商列表（通过状态）
     *
     * @param int $status 状态，1-审批，2-正常，4-取消，5-拒绝
     * @param array $columns 字段数组
     * @return array
     */
    public function getEnableSupplierListByStatus(int $status, array $columns = ['*']): array;
}