<?php

declare(strict_types=1);

namespace Meibuyu\Rpc\Service\Interfaces\DatacenterNew;


/**
 * @author chentianyu
 */
interface StockPlanServiceInterface
{

    /**
     * 获取历史销量分页
     * @param array $params ['year'=>2013,'sku'=>'aabbcc']
     * @return mixed
     * @author chentianyu
     */
    public function getProductChildrenHistorySalePaginate(array $params);

    /**
     * 导出历史销量
     * @param array $params ['year'=>2013,'sku'=>'aabbcc']
     * @return mixed
     * @author chentianyu
     */
    public function exportProductChildrenHistorySale(array $params);

    /**
     * 获取预测销量分页
     * @param array $params ['year'=>2013,'sku'=>'aabbcc']
     * @return mixed
     * @author chentianyu
     */
    public function getProductEstimateSalePaginate(array $params);

    /**
     * 导出预测销量
     * @param array $params ['year'=>2013,'sku'=>'aabbcc']
     * @return mixed
     * @author chentianyu
     */
    public function exportProductEstimateSale(array $params);


}