<?php

namespace Meibuyu\Rpc\Service\Interfaces\Production;

interface ProductionOrderServiceInterface
{

    /**
     * 根据对应的筛选条件获取对应的生产单相关信息
     * @param array $filters
     * @return mixed
     */
    public function getProductionOrderByFilter(array $filters, $columns = ['*'], $with = []);


    /**
     * 根据生产单号获取对应的成本单价
     * @param string $productionNo
     * @return mixed
     */
    public function getUnitCostPriceByProductNo(string $productionNo);
}
