<?php

namespace Meibuyu\Rpc\Service\Interfaces\Lingxing;

interface LingxingServiceInterface
{
    /**
     * 删除发货单
     *
     * @param string $shipmentSn 发货单号
     * @return array
     */
    public function deleteDeliveryOrder(string $shipmentSn): array;

    /**
     * 作废发货单
     *
     * @param string $shipmentSn 发货单号
     * @return array
     */
    public function invalidateDeliveryOrder(string $shipmentSn): array;

    /**
     *推送供应商
     * [
     *     'id_hwq', //供应商id
     *     'code',  //供应商编号
     *     'supplier_name', //供应商名称(取简称)
     * ]
     *
     */
    public function pushSupplier($data);

    /**
     * 创建收货单
     *
     * @param $attr
     * @return mixed
     */
    public function createReceiptOrder($attr);

    /**
     * 测试RPC
     *
     * @param $data
     * @return mixed
     */
    public function universalRpc($data);
}