<?php
/**
 * 团队产品
 *
 * @author zhangdongying
 * @date   2023-05-26
 */
declare(strict_types=1);

namespace Meibuyu\Rpc\Service\Interfaces\Product;

interface TeamProductServiceInterface
{
    /**
     * 获取分销产品列表
     *
     * @param array $teamIds 团队ID数组
     * @param array $childProductIds 仓库子产品SKU数组
     * @return array ['id', 'team_id', 'product_id', 'child_product_id', 'own_team_id', 'own_warehouse_id']
     */
    public function getDistributionProductListByTeamIds(array $teamIds, array $childProductIds = []): array;

    /**
     * 获取团队子产品列表
     *
     * @param array $teamIds 团队ID数组
     * @param array $childProductIds 仓库子产品ID数组
     * @return array keyBy('team_id')
     */
    public function getChildProductListByTeamIds(array $teamIds, array $childProductIds = []): array;

    /**
     * 根据产品ID获取列表
     *
     * @param array $productIds 仓库主产品ID数组
     * @param array $columns 列名数组
     * @return array keyBy('product_id')
     */
    public function getListByProductIds(array $productIds, array $columns = ['*']): array;
}