<?php
/**
 * 物流渠道
 *
 * @author zhangdongying
 * @date   2024-03-31
 */
declare(strict_types=1);

namespace Meibuyu\Rpc\Service\Interfaces\WmsAdmin;

interface WmsChannelServiceInterface
{
    /**
     * 获取物流渠道列表
     *
     * @param array $channelIds 物流渠道ID数组
     * @param array $columns 列名数组
     * @param array $relations 关联数组
     * @return array 默认keyBy('id')
     */
    public function getListByIds(array $channelIds, array $columns = ['*'], array $relations = []): array;
}
