<?php

/**
 * 新供应商rpc
 */

namespace Meibuyu\Rpc\Service\Interfaces\Supply;


interface SupplyServiceInterface
{


    /**
     * 获取
     * @param $id
     * @param $column
     * @param $sourceType 工厂系统 | 采购系统
     * @return mixed
     * @author Liu lu
     * date 2022-12-03
     */
    public function getSupplyByOldId($id,$column=['*'],$sourceType='工厂系统');


    /**
     * 获取供应商
     * @param array $ids
     * @param array $column
     * @param string $sourceType
     * @return mixed
     * @author Liu lu
     * date 2022-12-19
     */
    public function getSupplyListByRelatedIds(array $ids, $column = ['*'],$sourceType='工厂系统');



    /**
     * 通过名称批量获取供应商信息
     * @param $names 名称数组
     * @param string[] $column
     * @param string $searchType 搜索类型如 'material_supply' => 搜索原料供应商
     * @author Liu lu
     * date 2023-05-08
     */
    public function  getSupplyListByName($names,$column = ['*'],$searchType='');


    /**
     *
     * @param $factory_id
     * @return mixed
     */
    public function getSupplierInvoiceInformation($factory_id);


    /**
     * 获取工厂供应商发票税率、采购税率
     */
    public function getSupplierInfo();
}