<?php

namespace Meibuyu\Micro\Service\Interfaces\Production;

interface ProductionServiceInterface
{

    /**
     * 结束备货计划
     * @param $production_no
     * @return mixed
     */
    public function stockUpTask($production_no);

    /**
     * 查询备货计划中是否用过仓库子产品
     * @param array $ids 仓库子产品id数组,默认去重
     * @return array 返回用过的id数组
     */
    public function searchUsedProductChildId($ids);

    /**
     * 查询备货计划中是否用过平台子产品
     * @param array $ids 平台子产品id数组,默认去重
     * @return array 返回用过的id数组
     */
    public function searchUsedPlatformProductChildId($ids);

}
