<?php
/**
 * Created by PhpStorm.
 * User: 王源
 * Date: 2020/3/16
 * Time: 15:07
 */

namespace Meibuyu\Micro\Service\Interfaces;

interface StoreServiceInterface
{

    /**
     * 通过id列表获取仓库名称
     * @param array $idList 仓库id的列表, 默认去重
     * @param array $columns 仓库表的字段，默认显示全部
     * @return array 默认keyBy('id')
     */
    public function getByIdList(array $idList, array $columns = ['*']): array;


    /**
     * description:创建入库单
     * author: fuyunnan
     * @param array $data 需要入库的数组 格式请参考yapi 入库添加
     * @return array
     * @throws
     * Date: 2020/7/6
     */
    public function createWarehousing(array $data): array;


    /**
     * description:生产单结束获取统计单号值
     * author: fuyunnan
     * @param string $sourceNo 生产单号
     * @return array
     * @throws
     * Date: 2020/7/10
     */
    public function CntSourceNoOrder($sourceNo): array;


    /**
     * description:通过来源单号获取产品列表
     * author: fuyunnan
     * @param string $sourceNo 生产单号
     * @return array
     * @throws
     * Date: 2020/7/10
     */
    public function listSourceNoProduct($sourceNo): array;

}