<?php


namespace Meibuyu\Rpc\Service\Interfaces\PurchaseNew;


interface PurchaseInfoServiceInterface
{


    /**
     * 同步请款状态
     * 审核通过
     * {
         "purchase_id":"采购单id",
     *   "reject_reason":"驳回缘由", 审核驳回需要填充
     *   "flag":true|false  //true审核通过 false审核驳回
     * }
     * @return mixed
     */
    public function syncApplyMoneyStatus($post);

    /**
     * 扫描物流号或批次号查询
     * @param $scanNo
     * @return array
     */
    public function getShippingInfo($scanNo): array;

    /**
     * 分页查询
     * @param int $page 当前第几页
     * @param int $pageSize 每页显示数
     * @return array
     */
    public function getShippingList($page=1,$pageSize=10): array;


    /**
     * 根据批次号查询采购信息
     * @param array $batchNo 批次号数组
     * @return array
     */
    public function getPurchaseInfoArrByBatchNo(array $batchNo) :array;




    /**
     * 子订单号获取物流信息
     * @param  array $subOrderNos
     * @return array
     */
    public function getLogisticsInfo(array $subOrderNos);



    /**
     * 财务核算完成同步采购更新状态
     * @param $purchaseId
     * @return mixed
     */
    public function syncAccountingComplete($purchaseId):bool;
	
	
	
	/**
     * 根据sku查询采购时间/上架时间
     * @param array $skuArr sku数组 ['DSAU09-Animals-73','DSAU13-Strawberry-66']
     * @return array
     */
    public function getPurchaseTimeArrBySku(array $skuArr) :array;


    /**
     * 根据对应的批次号和产品 ID 获取对应的采购陈本单价
     * @param $batchNo
     * @param $productId
     * @return mixed
     */
    public function getProductUnitPriceByBatchNo($batchNo, $productId);


    /**
     * Notes: 通过订单号获取采购状态
     * User: carlos
     * DateTime: 2023/8/11 9:17
     * @param $orders
     */
    public function getPurchaseStatusBySubOrders($orders): array;

    /**
     * 获取采购单列表
     *
     * @param array $purchaseNos 采购单号，数组
     * @param array $columns 列名，数组
     * @return array keyBy('purchase_no')
     */
    public function getPurchaseOrderListByNos(array $purchaseNos, array $columns = ['*']): array;

    /**
     * 获取采购单列表（根据批次号）
     *
     * @param array $batchNos 批次号，数组
     * @param array $columns 列名，数组
     * @return array keyBy('batch_no')
     */
    public function getPurchaseOrderListByBatchNo(array $batchNos, array $columns = ['*']): array;
}