<?php

namespace Meibuyu\Rpc\Service\Interfaces\Production;

use App\Repository\Eloquent\SaveStock\StockProductionRepository;

interface StFactoryProductionOrderServiceInterface
{
    /**
     * Notes: 创建生产订单
     * User: carlos
     * DateTime: 2023/4/3 9:31
     */
    public function createOrder($params);

    /**
     * Notes: 获取可生产sku列表
     * User: carlos
     * DateTime: 2023/4/3 9:36
     * @param int $factoryId
     * @return array
     */
    public function getSkuSelectList(int $factoryId) :array;


    /**
     * Notes: 获取可以创建生产订单产品列表
     * User: carlos
     * DateTime: 2023/4/3 9:44
     * @param $params
     * @return array
     */
    public function getProductsList($params) :array;


    /**
     * 储备生产列表
     * @param $params
     * @return array
     * @author Liu lu
     * date 2023-04-04
     */
    public function stockProductionList($params);

    /**
     * 储备生产列表tab数量
     * @param $params
     * @return array[]
     * @author Liu lu
     * date 2023-04-04
     */
    public function stockProductionTabList($params);
}