<?php


namespace Meibuyu\Rpc\Service\Interfaces\PurchaseNew;


interface PurchaseDemandServiceInterface
{


    /**
     * 同步请款状态
     * 审核通过
     * {
         "purchase_id":"采购单id",
     *   "reject_reason":"驳回缘由", 审核驳回需要填充
     *   "flag":true|false  //true审核通过 false审核驳回
     * }
     * @return mixed
     */
    public function createPurchaseDemand(array $data);

    /**
     * 扫描物流号或批次号查询
     * @param array $demandIds
     * @return bool
     */
    public function deleteDemandByIds(array $demandIds): bool;


    /**
     * 批量取消采购
     * @param array $subOrderNos 子单号数组
     * @param array $user Auth::user()
     * @author Liu lu
     * date 2023-01-10
     */
    public function batchCancelPurchase(array $subOrderNos,$user);


    /**
     * 订单系统发送to采购消息
     * @param $params
     */
    public function sendMessageByOrder($params);


    /**
     * 获取采购、订单消息
     * @param $params
     * @return mixed
     */
    public function getMessagePurchase($params);
}