<?php

namespace Meibuyu\Rpc\Service\Interfaces\Production;

use App\Model\ApprovalFlowConfiguration;
use Meibuyu\Micro\Exceptions\HttpResponseException;

interface ProductionServiceInterface
{

    /**
     * 生产单批次发货入库回调
     * @param array $params
     * [
     *   'production_no' => 'SC20201218-001-001', // 生产单号,必须
     *   'auth' => Auth::user(), // 当前用户,必须
     *   'warehousing_order' => [
     *     'id' => '123', // 入库单id,必须
     *     'warehousing_no' => 'RK-20200727-001', // 入库单号,必须
     *     'count' => '123', // 入库数量, 必须
     *   ]
     * ]
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function warehousingCallback(array $params);

    /**
     * 通过入库单id获取相关数据
     * @param array $warehousingOrderIds 默认去重
     * @return array 默认keyBy
     */
    public function getInfoForWarehousingOrder(array $warehousingOrderIds);

    /**
     * 通过生产单号获取生产单工厂信息
     * @param array $productionNoList 生产单号数组,默认去重
     * @return array 'production_no' => ['factory_id' => 1, 'factory_name' => 'AL']
     * @author Zero
     */
    public function getFactoryByProductionNoList(array $productionNoList): array;

    /**
     * 查询备货计划中是否用过仓库子产品
     * @param array $ids 仓库子产品id数组,默认去重
     * @return array 返回用过的id数组
     */
    public function searchUsedProductChildId($ids);

    /**
     * 查询备货计划中是否用过平台子产品
     * @param array $ids 平台子产品id数组,默认去重
     * @return array 返回用过的id数组
     */
    public function searchUsedPlatformProductChildId($ids);

    /**
     * 通过生产单号获取生产单产品数据
     * @param $productionNo
     * @return array
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function getProductionProductInfoByNo($productionNo): array;

    /**
     * 仓库返工出库回调
     * @param array $params
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function exWarehouseCallback(array $params);



    /**
     * 获取生产单留言信息
     * @param array $params
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function  productionMessages($params);


    /**
     * 生产单留言操作
     * @param array $params
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function  toMessage($params);

    /**
     * 获取生产单列表是否有未读消息
     * @param $productionNoArr
     * @param string $source
     */
    public function getListMessageReadStatus($productionNoArr,$source='factory');

    /**
     * 更新备货计划产品工艺单维护信息
     * @param $productId 产品id
     * @param $status 工艺维护状态 0未维护，1已维护，2部分维护
     * @return mixed
     */
    public function productCraftMaintain($productId,$status);

    /**
     * 获取生产单信息
     * @param $productionNoArr 生产单号
     * @param array $columns 生产主表字段
     * @param $relation 关联信息
     * @return mixed
     */
    public function productionInfo($productionNoArr,$columns = ['*'],$relation=['production_order_products']);



    /**
     * 根据订单汇总消息
     * @return mixed
     */
    public function getProductionCountMessage();


    /**
     * 获取订单留言表的product_order_id
     * @return mixed
     */
    public function getMessageProductionOrderIds();


    /**
     * 发送留言
     * @return mixed
     */
    public function pushProductionMessage(array $params);


    /**
     * 获取留言
     * @return mixed
     */
    public function getProductionMessage(array $params);


    /**
     * 已读标记
     * @return mixed
     */
    public function isReadProductionMessage(array $params);

    /**
     * Notes: 获取礼服备货单信息
     * User: carlos
     * DateTime: 2022/11/8 18:48
     * @param $code
     * @return array
     */
    public function getStockUpOrder($code): array;

    /**
     * Notes: 收货
     * User: carlos
     * DateTime: 2022/11/21 10:34
     * [
     *      'delivery_no' => '', //发货单号
     *      'package_num' => , //收到包裹数量
     *      'user_id'     => '', //收货人id
     *      'user_name'   => '', //收货人姓名
     * ]
     */
    public function confirmDelivery($params);

    /**
     * Notes: 取消发货订单
     * User: carlos
     * DateTime: 2022/11/22 9:20
     * @param $params
     */
    public function cancelDelivery($params);

    /**
     * Notes: 创建生产异常单
     * User: carlos
     * DateTime: 2022/11/21 16:36
     */
    public function createProductionException($params);


    /**
     * Notes: 返修退回
     * User: carlos
     * DateTime: 2022/11/22 13:58
     */
    public function repairReturn($params);

    /**
     * 发送留言-小货
     * @param $params
     * @throws HttpResponseException
     */
    public function pushOutsideMessage($params);

    /**
     * Notes: 获取小货-留言
     * User: carlos
     * DateTime: 2022/11/26 10:40
     */
    public function getOutsideMessage($id);


    /**
     * Notes: 获取礼服备货审核信息
     * User: carlos
     * DateTime: 2022/11/29 16:59
     * @param $code
     */
    public function getStockUpDressApproval($code);


    /**
     * Notes: 飞书审批回调
     * User: carlos
     * DateTime: 2022/11/30 19:09
     * @param $params
     */
    public function stockUpDetailCallBack($params);


    /**
     * 工厂信息合同
     * @param $params
     * @author Lin jixin
     * date 2023/1/11 10:28
     */
    public function contractInfo($params);


    /**
     * 下载合同
     * @param $params
     * @author Lin jixin
     * date 2023/1/11 15:48
     */
    public function dowloadContract($params);


    /**
     * 下载销售订单合同
     * @param $params
     * @author Lin jixin
     * date 2023/1/13 10:48
     */
    public function OrderContractExport($params);


    /***
     * Notes: 获取备货金额信息
     * User: carlos
     * DateTime: 2023/5/12 16:56
     */
    public function getStockUpPlanMoneyInfo();



    /**
     * 获取订单是否为组合产品
     * @param $stockUpPlanIds
     */
    public function getGroupProduct($stockUpPlanIds);


    /**
     * 检查审批配置是否开启操作规则
     * @param $operation_type
     * @return bool
     */
    public function getApprovalTypeIsTrue($operation_type);


    /**
     * 获取跟单员、订单类型、合作方式
     */
    public function getProductionOrderMember();


    /**
     * 通过订单号获取备货计划信息
     * @param $ProductionOrders
     */
    public function getStockPlanInfo($ProductionOrders);


    /**
     * 保存二次分派跟单员
     * @param $params
     */
    public function saveApportionProcessUser($params);

}
