<?php
/**
 * Created by PhpStorm.
 * User: 王源
 * Date: 2020/3/16
 * Time: 15:07
 */

namespace Meibuyu\Rpc\Service\Interfaces\Store;

interface StorePurchaseServiceInterface
{

    /**
     * 继续入库
     * [
     *  'purchase_no' => '',       //采购单号（必填）
     *  'batch_no'    => '',       //批次号（必填）
     *  'extra'       => [],       //后续扩展使用可以，非必填
     * ]
     * @param array $params
     * @return array
     * [
            'msg' => '退货成功',
            'code'=> 200,                       //响应码
            'data' => []                        //返回的数据
        ];
     */
    public function continueWarehousing(array $params): array;


    /**
     * 单个产品继续入库
     * [
     *  'detail_id' => 1221'
     *  'num'       => 10,       //批次号（必填）
     * ]
     * @param array $params
     * @return array
     * [
        'msg'  => '继续入库成功',
        'code' => 200,
        'data' => []
      ];
     */
    public function productContinueWarehousing(array $params): array;


    public function syncStoredRealTime($batchNos);


    /**
     * 获取对应的采购异常
     * @param $batchNo
     * @param $subOrderNo
     * @param $extraParams 兼容额外的场景的可选参数
     */
    public function getPurchaseQcException($batchNo, $subOrderNo, $extraParams = []);

    /**
     * 子订单退货（子订单入库后退货）
     *
     * @param string $subOrderNo 子订单号
     * @param int $returnedCnt 退货数量
     * @param string $receivedBy 收货人
     * @param string $contactTel 联系电话
     * @param string $returnAddress 退货地址
     * @param array $extra 额外参数
     * @return array ['code' => 200, 'msg' => '', 'data' => ['reference_no' => '111111111']]
     */
    public function returnSubOrderWarehousedGoods(string $subOrderNo, int $returnedCnt, string $receivedBy, string $contactTel, string $returnAddress, array $extra = []): array;

    /**
     * 子订单退货（子订单入库后取消）
     *
     * @param string $subOrderNo 子订单号
     * @param int $returnedCnt 退货数量
     * @param string $receivedBy 收货人
     * @param string $contactTel 联系电话
     * @param string $returnAddress 退货地址
     * @param array $extra 额外参数
     * @return array ['code' => 200, 'msg' => '', 'data' => ['reference_no' => '111111111']]
     */
    public function returnSubOrderGoodsByCancel(string $subOrderNo, int $returnedCnt, string $receivedBy, string $contactTel, string $returnAddress, array $extra = []): array;

    /**
     * 更新退货信息
     *
     * @param string $subOrderNo 子订单号
     * @param string $referenceNo 关联单号
     * @param string $receivedBy 收货人
     * @param string $contactTel 联系方式
     * @param string $returnAddress 退货地址
     * @return array
     */
    public function updateReturnInfo(string $subOrderNo, string $referenceNo, string $receivedBy, string $contactTel, string $returnAddress): array;
}
