<?php


namespace Meibuyu\Rpc\Service\Interfaces\OutsideFactory;


use App\Services\Production\ProductionExceptionService;

interface FactoryServiceInterface
{


    /**
     * 打印工艺单信息 返回导出地址
     * @param $craftInfo
     * @return String
     */
    public function productCraftPrint($craftInfo) ;

    /**
     * 打印发货单
     * @param $deliveryNo 发货单号
     * @return mixed
     */
    public function downDeliveryRecord($deliveryNo);
    /**
     * 获取对应的工厂信息
     * @param array $factoryIds
     * @param array|string[] $columns
     * @return mixed
     */
    public function getFactories(array $factoryIds = [], array $columns = ['*']);

    /**
     * 根据筛选条件获取对应的工厂信息
     * @param array $filters 筛选条件
     * @param array|string[] $columns 查询字段
     * @return mixed
     */
    public function getFactoriesByFilters(array $filters = [], array $columns = ['*']);

    /**
     * 生产端留言投递到工厂端订单表
     * @param array $production_no  生产单号
     * @return mixed
     */
    public function toProductOrderMessage(array $post);

    /**
     *  工厂列表
     * @param string  $id 工厂id
     * @return array  $list
     */
    public function factoryList();

    /**
     *  子工厂列表
     * @return array  $list
     */
    public function  childFactoryList($id);


    /**
     *  工厂树状列表
     * @return array  $list
     */
    public function treeFactoryList();


    /**
     * 获取分派详情通过来源订单号
     * @param $originalProductionNos
     * @return array|mixed
     * @author Liu lu
     * date 2022-09-19
     */
    public function getApportionInfoListByNos($originalProductionNos);


    /**
     * Notes: 分派订单取消
     * User: carlos
     * @param string $type cancel|delete
     * DateTime: 2022/9/21 14:24
     */
    public function cancelOrder($orderNo, $type = 'cancel');

    /**
     * Notes: 获取订单信息
     * User: carlos
     * DateTime: 2022/9/22 16:21
     * @param $orderNo
     */
    public function getProductionOrder($orderNo, $columns =['*'],$with=[]);



    /**
     * 获取供应链获取工厂端生产对账单
     * @param $searchConditions 搜索条件
     * @param bool $isExport 是否导出
     * @return array|\Hyperf\Contract\LengthAwarePaginatorInterface|mixed
     * @author Liu lu
     * date 2022-09-27
     */
    public function getProductionAccountStatement($searchConditions,$isExport=false);


    /**
     * 供应链获取工厂端生产对账单数量
     * @param $searchConditions 搜索条件
     * @return int
     * @author Liu lu
     */
    public function getProductionAccountCount($searchConditions);


    /**
     * Notes: 生产订单完结
     * User: carlos
     * DateTime: 2022/9/29 9:52
     */
    public function finishProductionOrder($orderSn);

    /**
     * Notes: 确认收货
     * User: carlos
     * DateTime: 2022/11/21 14:14
     */
    public function confirmDelivery($params);


    /**
     * Notes: 通过最小订单号批量获取原始订单号
     * @param $orderNoArr
     * @param string[] $columns
     * @param $with[] $with
     * @return array
     */
    public function getProductionListByOrderNo($orderNoArr, $columns =['*'],$with=[]);

    /**
     * Notes: 少货处理
     * User: carlos
     * DateTime: 2022/11/21 19:03
     */
    public function shortageProcess($delivery_no, $shortageProduct);


    /**
     * Notes: 退回返修
     * User: carlos
     * DateTime: 2022/11/23 11:43
     * @param $params
     */
    public function repairReturn($delivery_no, $repairProducts);

    /**
     * Notes: 处理到仓返修异常
     * User: carlos
     * DateTime: 2022/11/27 9:23
     */
    public function processWarehouseRepair($params);



    /**
     * 推送供应商数据到工厂系统
     * @author Liu lu
     * @param $post demo
        {
        `name` '工厂名称',
        `abbreviation`  '简称',
        `code`  '代码',
        `manager_id`  '管理者id',
        `phone` '电话',
        `address`  '地址',
        `score`  '平均评分',
        `creator_id` '创建人id',
        `type_id`  '类型',
        `remark` '备注',
        `can_invoice`  '能否开发票，默认为 0，可以开票为 1',
        `status`  '状态 1:正常 0:停用',
        `is_transfer`  '能否转派 1:能 0:不能'
        }
     * @return int 主键id
     */
    public function pushSupplyDataToFactory($post);

    /**
     * Notes: 发货状态
     * User: carlos
     * DateTime: 2022/12/5 10:08
     */
    public function updateDeliveryStatus($params);















    /***
     * 账单标记结算
     * 发货表与返修出库表标记已结算
     * @param $params
     * @author Liu lu
     * date 2022-12-19
     */
    public function billMarkSettled($params);


    /**
     * 生产通知单下载
     * @param $originProductionNo
     * @author Liu lu
     * date 2023-02-02
     */
    public function productionNoticeDownload($originProductionNo);

    /**
     * 获取工艺单地址
     * @param $deliveryNo 发货单号
     * @author Jack
     * date 2023-02-17
     */
    public function getCraftDocAddressByDeliveryNo($deliveryNo);


    /**
     * 通过名称获取工厂信息
     * @param $params
     * @return mixed
     */
    public function getFactoryInfoByNames($params);
}