<?php


namespace Meibuyu\Rpc\Service\Interfaces\OutsideFactory;


interface FactoryServiceInterface
{


    /**
     * 打印工艺单信息 返回导出地址
     * @param $craftInfo
     * @return String
     */
    public function productCraftPrint($craftInfo) ;

    /**
     * 打印发货单
     * @param $deliveryNo 发货单号
     * @return mixed
     */
    public function downDeliveryRecord($deliveryNo);
    /**
     * 获取对应的工厂信息
     * @param array $factoryIds
     * @param array|string[] $columns
     * @return mixed
     */
    public function getFactories(array $factoryIds = [], array $columns = ['*']);

    /**
     * 根据筛选条件获取对应的工厂信息
     * @param array $filters 筛选条件
     * @param array|string[] $columns 查询字段
     * @return mixed
     */
    public function getFactoriesByFilters(array $filters = [], array $columns = ['*']);

    /**
     * 生产端留言投递到工厂端订单表
     * @param array $production_no  生产单号
     * @return mixed
     */
    public function toProductOrderMessage(array $post);

    /**
     *  工厂列表
     * @param string  $id 工厂id
     * @return array  $list
     */
    public function factoryList();

    /**
     *  子工厂列表
     * @return array  $list
     */
    public function  childFactoryList($id);


    /**
     *  工厂树状列表
     * @return array  $list
     */
    public function treeFactoryList();


    /**
     * 获取分派详情通过来源订单号
     * @param $originalProductionNos
     * @return array|mixed
     * @author Liu lu
     * date 2022-09-19
     */
    public function getApportionInfoListByNos($originalProductionNos);


    /**
     * Notes: 分派订单取消
     * User: carlos
     * DateTime: 2022/9/21 14:24
     */
    public function cancelOrder($orderNo);

    /**
     * Notes: 获取订单信息
     * User: carlos
     * DateTime: 2022/9/22 16:21
     * @param $orderNo
     */
    public function getProductionOrder($orderNo, $columns =['*']);



    /**
     * 获取供应链获取工厂端生产对账单
     * @param $searchConditions 搜索条件
     * @param bool $isExport 是否导出
     * @return array|\Hyperf\Contract\LengthAwarePaginatorInterface|mixed
     * @author Liu lu
     * date 2022-09-27
     */
    public function getProductionAccountStatement($searchConditions,$isExport=false);
}