<?php
/**
 * Created by PhpStorm.
 * User: Zero
 * Date: 2020/8/19
 * Time: 9:06
 */

namespace Meibuyu\Micro\Tools;

use GuzzleHttp\Client;
use Psr\Http\Message\ResponseInterface;

/**
 * json格式请求(非协程)
 * Class HttpRequestJson
 * @package Meibuyu\Micro\Tools
 */
class HttpRequestJson
{

    /**
     * get请求
     * @param $url
     * @param array $httpHeaders
     * @return ResponseInterface
     */
    public static function get($url, $httpHeaders = [])
    {
        $client = new Client(['timeout' => 30]);
        return $client->get($url, ['headers' => $httpHeaders]);
    }

    /**
     * post请求
     * @param $url
     * @param $dataArray
     * @param array $httpHeaders
     * @return ResponseInterface
     */
    public static function post($url, $dataArray, $httpHeaders = [])
    {
        $client = new Client(['timeout' => 30]);
        return $client->post($url, ['headers' => $httpHeaders, 'json' => $dataArray]);
    }

    /**
     * put请求
     * @param $url
     * @param $dataArray
     * @param array $httpHeaders
     * @return ResponseInterface
     */
    public static function put($url, $dataArray, $httpHeaders = [])
    {
        $client = new Client(['timeout' => 30]);
        return $client->put($url, ['headers' => $httpHeaders, 'json' => $dataArray]);
    }

    /**
     * delete请求
     * @param $url
     * @param array $httpHeaders
     * @return ResponseInterface
     */
    public static function delete($url, $httpHeaders = [])
    {
        $client = new Client(['timeout' => 30]);
        return $client->delete($url, ['headers' => $httpHeaders]);
    }

}
