<?php
/**
 * Created by PhpStorm.
 * User: zhaopeng
 * Date: 2020/9/1
 * Time: 10:09
 */
namespace Meibuyu\Micro\Service\Interfaces\Order;

interface SubOrderServiceInterface
{

    /**
     * @param int $id
     * @param array $column  需要查询的字段
     * @param array $relation 需要的子订单关联关系可传入['order','order_product']
     * @return array | null
     */
    public function getById(int $id, array $column=['*'],array $relation = []):array;

    /**
     *
     * @param array $idList 子订单的ID  数组[1,2,3]
     * @param array $column 需要查询字段
     * @param array $relation 需要的关联关系可传入['order','order_product']
     * @return array | null
     */
    public function getByIdList(array $idList,array $column=['*'],array $relation = []):array ;

    /**
     * @param array $idList 需要改变发货状态的子订单ID数组
     * @param int $status 需要改变的发货状态ID 1 待发货 2 已发货 3 已签收 4 已取消
     * @return bool
     */
    public function updateSubOrderShipStatus(array $idList, int $status):bool;


}