<?php


namespace Meibuyu\Rpc\Service\Interfaces\OutsideFactory;


interface FactoryServiceInterface
{


    /**
     * 打印工艺单信息 返回导出地址
     * @param $craftInfo
     * @return String
     */
    public function productCraftPrint($craftInfo) ;

    /**
     * 打印发货单
     * @param $deliveryNo 发货单号
     * @return mixed
     */
    public function downDeliveryRecord($deliveryNo);
    /**
     * 获取对应的工厂信息
     * @param array $factoryIds
     * @param array|string[] $columns
     * @return mixed
     */
    public function getFactories(array $factoryIds = [], array $columns = ['*']);

    /**
     * 根据筛选条件获取对应的工厂信息
     * @param array $filters 筛选条件
     * @param array|string[] $columns 查询字段
     * @return mixed
     */
    public function getFactoriesByFilters(array $filters = [], array $columns = ['*']);

    /**
     * 生产端留言投递到工厂端订单表
     * @param array $production_no  生产单号
     * @return mixed
     */
    public function toProductOrderMessage($production_no);
}