<?php

/**
 * 供应链礼服备货小货发货相关rpc服务
 */

namespace Meibuyu\Rpc\Service\Interfaces\Production;


interface ExternalDeliveryServiceInterface
{

    /**
     * 查看指定生产单发货记录
     * @param $params
     * @author Liu lu
     * date 2022-11-11
     */
    public function productionDeliveryDetail($params);


    /**
     * 创建发货记录
     * @param $params
     * @author Liu lu
     * date 2022-11-14
     */
    public function  createDeliveryRecord($params);

    /**
     * 待确认发货详情展示
     * @param $productionId
     * @author Liu lu
     * date 2022-11-14
     */
    public function  deliveryPendingDisplay($productionId);

    /**
     * 小货-发货记录
     * @param $params
     * @author Linjixin
     * date 2022-11-15
     */
    public function deliveryRecordsList($params);


    /**
     * 小货-发货记录导出
     * @param $params
     * @author Linjixin
     * date 2022-11-15
     */
    public function deliveryRecordsListExport($params);


    /**
     * 通过发货单号获取发货信息
     * @param $deliveryNoArr 发货单号
     * @param $relation  关联模型 拿到发货产品信息 ['dispatch_products]
     * @param $columns
     * @return array  ['发货单号'=>array()]
     * @author Liu lu
     * date 2022-11-15
     */
    public function getListInfoByDeliveryNo($deliveryNoArr,$relation=['dispatch_products'],$columns=['*']);


    /**
     * Notes: 获取发货详情
     * User: carlos
     * DateTime: 2022/11/16 10:09
     */
    public function getDeliveryRecord($delivery_no);



    /**
     * 小货工作台-异常待办/预警事项/进行中的订单
     * @param $params
     * @author Lin jixin
     * date 2022/11/18 10:03
     */
    public function  Totals($params);


    /**
     * 工作台-交付情况
     * @param $params
     * @author Lin jixin
     * date 2022/11/18 10:06
     */
    public function handOver($params);



    /**
     * 逾期与近交期订单
     * @param $params
     * @author Lin jixin
     * date 2022/11/17 11:48
     */
    public function overdueOrCloseDelivery($params);


    /**产品质量
     * @param $params
     * @author Lin jixin
     * date 2022/11/17 11:51
     */
    public function  quality($params);


    /**排行榜
     * @param $params
     * @author Lin jixin
     * date 2022/11/17 11:51
     */
    public function rank($params);


    /**
     * 工作台下单情况
     * @param $params
     * @author Lin jixin
     * date 2022/11/21 15:28
     */
    public function OrderNum($params);


    /**
     * 工厂端异常退回记录
     * @param $params
     * @author Lin jixin
     * date 2022/11/25 14:08
     */
    public function AbnormalReturnRecord($params);

}