<?php

namespace Meibuyu\Rpc\Service\Interfaces\Notice;

interface FactoryNoticeServiceInterface
{

    /**
     * 分页
     * @param $userInfo
     * @param $params
     * @author chentianyu
     */
    public function page($userInfo,$params);

    /**
     * 未读列表
     * @param $userInfo
     * @param $params
     * @author chentianyu
     */
    public function unReadList($userInfo,$params);

    /**
     * 查看
     * @param $userInfo
     * @param $params
     * @author chentianyu
     */
    public function show($userInfo,$params);

    /**
     * 下一条未读的记录
     * @param $userInfo
     * @param $params
     * @author chentianyu
     */
    public function nextUnRead($userInfo,$params);

    /**
     * 标记为已读
     * @param $userInfo
     * @param $params
     * @author chentianyu
     */
    public function markRead($userInfo,$params);

    /**
     * 打包下载
     * @param $noticeId
     * @author chentianyu
     */
    public function pack($noticeId);


}
