<?php


namespace Meibuyu\Rpc\Service\Interfaces\Product;


interface FactoryProductServiceInterface
{

    /**
     * 运营端-工厂库存
     * @param $params
     */
    public function productStockList($params);


    /**
     * 插入工厂库存数据
     * @param $insertData
     */
    public function insertFactoryStockData($insertData);


    /**
     * 判断是否存在导入产品sku，如果有 则展示工厂导入产品的列表
     * @param $factory_id
     */
    public function isExistFactoryProduct($factory_id);


    public function getFactoryStockList($params);


    /**
     * 查询子产品目前有多少导入的产品库存和生产中的库存
     * @param $product_child_ids
     * @param $factoryId
     */
    public function getUsefulStockAndProducingStockByChildId($product_child_ids,$factoryId);

}