<?php
/**
 * Created by PhpStorm.
 * User: 王源
 * Date: 2020/1/9
 * Time: 15:07
 */

namespace Meibuyu\Rpc\Service\Interfaces\Product;

interface ProductServiceInterface
{

    /**
     * 获取单个数据
     * @param int $id 产品id
     * @param array $relations 产品的关联关系，支持：["brand","category","ingredient","product_name","status","type","images","price_info","product_children"]
     * @param array $columns 产品表的字段，默认
     * ['id', 'sku', 'name', 'en_name', 'brand_id', 'team_id', 'hs_code', 'origin_country_id', 'production_address',
     * 'unit', 'category_id', 'ingredient_id', 'product_name_id', 'type_id', 'status_id', 'style', 'info_completed'
     * , 'bar_code', 'bar_code_image', 'creator_id', 'hot']
     * @return array|null
     */
    public function get($id, array $relations = [], array $columns = ['*']);

    /**
     * 通过id列表获取产品数组
     * @param array $idList 产品id的列表, 默认去重
     * @param array $relations 产品的关联关系，支持["brand","category","ingredient","product_name","status","type","images","price_info","product_children"]
     * @param array $columns 产品表的字段，默认['id', 'sku', 'name', 'en_name', 'brand_id'
     * , 'team_id', 'hs_code', 'origin_country_id', 'production_address', 'unit', 'category_id'
     * , 'ingredient_id', 'product_name_id', 'type_id', 'status_id', 'style', 'info_completed'
     * , 'bar_code', 'bar_code_image', 'creator_id', 'hot']
     * @return array 默认keyBy('id')
     */
    public function getByIdList(array $idList, array $relations = [], array $columns = ['*']): array;

    /**
     * 通过sku列表获取产品列表
     * @param array $skuList 默认去重
     * @param array $relations 产品的关联关系,可传入['color', 'size','brand', 'category', 'product_name', 'images', 'cost', 'weight']
     * @param array $columns 产品表的字段，默认返回id
     * @return array 默认keyBy('sku')
     */
    public function getListBySkuList(array $skuList, array $relations = [], array $columns = ['id']);

    /**
     * 获取全部品类列表
     * @param bool $asTree 是否作为树返回
     * @param array $columns 默认['id', 'name', 'parent_id']
     * @return array
     */
    public function categories($asTree = false, array $columns = ['id', 'name', 'parent_id']): array;

    /**
     * 获取全部品牌列表
     * @param array $columns 默认['id', 'name']
     * @return array
     */
    public function brands(array $columns = ['id', 'name']): array;

    /**
     * 获取全部报关品名列表
     * @param array $columns 默认['id', 'name','en_name']
     * @return array
     */
    public function productNames(array $columns = ['id', 'name', 'en_name']): array;

    /**
     * 获取全部成分列表
     * @param array $columns 默认['id', 'name']
     * @return array
     */
    public function ingredients(array $columns = ['id', 'name', 'en_name']): array;

    /**
     * 通过id数组获取品类列表
     * @param array $ids 默认去重
     * @param array $columns
     * @return array 默认keyBY('id')
     */
    public function getCategoriesByIds(array $ids, array $columns = ['id', 'name', 'parent_id']): array;

    /**
     * 通过id数组获取品名列表
     * @param array $ids 默认去重
     * @param array $columns
     * @param array $relations ['report_points']
     * @return array 默认keyBY('id')
     */
    public function getProductNamesByIds(array $ids, array $columns = ['id', 'name', 'en_name'], array $relations = []): array;

    /**
     * 通过id获取品类
     * @param int $id
     * @param array $columns
     * @return array|null
     */
    public function getCategoryById(int $id, array $columns = ['id', 'name', 'parent_id']);

    /**
     * 通过id获取品名
     * @param int $id
     * @param array $columns
     * @param array $relations ['report_points']
     * @return array|null
     */
    public function getProductNameById(int $id, array $columns = ['id', 'name', 'en_name'], array $relations = []);

    /**
     * 通过id数组获取申报要素列表
     * @param array $ids 默认去重
     * @param array $columns
     * @param array $relations ['product_name', 'ingredient']
     * @return array 默认keyBY('id')
     */
    public function getReportPointsByIds(array $ids, array $relations = [], array $columns = ['id', 'hs_code', 'point']): array;

    /**
     * 通过id获取申报要素
     * @param int $id
     * @param array $columns
     * @param array $relations ['product_name', 'ingredient']
     * @return array|null
     */
    public function getReportPointById(int $id, array $relations = [], array $columns = ['id', 'hs_code', 'point']);

    /**
     * 获取申报要素数据
     * @param array $idList 默认去重
     * @param bool $groupByFlag
     * @return array keyBy('id')
     */
    public function getWithPoint(array $idList, $groupByFlag = false);

    /**
     * 获取全部申报要素列表
     * @param array $columns 默认['*']
     * @return array
     */
    public function reportPoints(array $columns = ['*']): array;

    /**
     * 通过产品id获取维护的所有尺码
     * @param $id
     * @return array
     * @author Zero
     */
    public function getSizesById($id): array;

    /**
     * 完成产品审批
     * @param $data
     * @author Zero
     */
    public function downApprove($data);

//    /**
//     * 通过id数组获取品牌列表
//     * @param array $ids 默认去重
//     * @param array $columns
//     * @return array 默认keyBY('id')
//     */
//    public function getBrandsByIds(array $ids, array $columns = ['id', 'name']): array;

    /**
     * 样品转换产品
     * @param array $params 传入的参数
     * $params = [
     *     'product' => [ // 产品信息
     *         'sku' => 'ABC123', // SKU,必填
     *         'name' => '裙子', // 产品中文名,选填
     *         'en_name' => 'dress', // 产品英文名,选填
     *         'brand_id' => 123, // 品牌id,选填
     *         'team_ids' => [1,2,3], // 团队id数组,选填
     *         'hs_code' => '6109909060', // 海关编号,选填
     *         'origin_country_id' => 123, // 原产国,选填
     *         'production_address' => '苏州', // 境内货源地,选填
     *         'unit' => '件', // 单位,必填
     *         'category_id' => 123, // 品类id,必填
     *         'ingredient_id' => 123, // 成分id,选填
     *         'product_name_id' => 123, // 品名id,必填
     *         'style' => '复古', // 风格/款式,选填
     *         'creator_id' => 123, // 创建人id,必填
     *         'images' => [], // 图片地址数组
     *         'cost' => 12,5, // 生产成本
     *         'package_cost' => 12,5, // 包装成本
     *         'customs_unit_price' => 12,5, // 报关单价
     *         'customs_cost' => 12,5, // 报关成本
     *         'product_weight' => 15.2, // 产品重量(g)
     *         'product_length' => 15.2, // 产品长度(cm)
     *         'product_width' => 15.2, // 产品宽度(cm)
     *         'product_height' => 15.2, // 产品高度(cm)
     *         'product_volume' => 15.2, // 产品体积(cm3)
     *         'package_weight' => 15.2, // 包装重量(g)
     *         'package_length' => 15.2, // 包装长度(cm)
     *         'package_width' => 15.2, // 包装宽度(cm)
     *         'package_height' => 15.2, // 包装高度(cm)
     *         'package_volume' => 15.2, // 包装体积(cm3)
     *     ],
     *     'material' => [] // 原料信息,暂无
     * ];
     * @return array
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function specimenTransformToProduct(array $params);

    /**
     * 检查产品是否上架
     * @param array $params
     * 参数可以通过id数组或者sku数组查询,二者传一就行,都传仅id生效
     * $params = [
     *     'ids' => [1,2,3], // 产品id数组
     *     'skus' => ['sku1', 'sku2', 'sku3'], // 产品sku数组,全等查询非模糊
     * ];
     * @param array $relations 产品的关联关系,默认空
     * 支持：["brand","category","ingredient","product_name","status","type","images","price_info","product_children"]
     * @param array $columns 产品表的字段，默认全部字段
     * 支持：['id', 'sku', 'name', 'en_name', 'brand_id', 'hs_code', 'origin_country_id', 'production_address',
     * 'unit', 'category_id', 'ingredient_id', 'product_name_id', 'type_id', 'status_id', 'style',
     * 'info_completed',  'creator_id']
     * @return array 返回已上架产品信息
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function checkPublished(array $params, array $relations = [], array $columns = ['*']): array;
	
	
	 /**
     * 检查产品是否同时维护工艺信息核原料信息
     * @param 
	 * 参数可以通过id
     * @return bool 同时维护true，未同时维护false
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
	 public function checkMaterialCraftById($id);
	 
	  /**
     * 通过产品id 获取工艺信息
     * @param 
	 * 参数产品id数组
     * @return array
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
	 public function getCraftByProductIds(array $productIds);

    /**
     * 获取产品数据
     * @param array $where
     * @param array $select
     * @param array|null $limitIds
     * @return array
     * @author chentianyu
     */
    public function getProductsByWhere(array $where, array $select = ['id'], array $limitIds = null): array;

    /**
     * 获取报关品名
     * @param array $where
     * @param array $select
     * @param array|null $limitIds
     * @return array
     * @author chentianyu
     */
    public function getProductNamesByWhere(array $where, array $select = ['id'], array $limitIds = null): array;

    
}
