<?php
/**
 * Created by PhpStorm.
 * User: qjk
 * Date: 2022/03/28
 * Time: 15:07
 */

namespace Meibuyu\Rpc\Service\Interfaces\User;

interface AuthenticationInterface
{

    /**
     * 获取对应用户能够看到的菜单
     * @param string $applicationName
     * @param integer $userId
     * @return array
     */
    public function getMenus($applicationName, $userId): array;


    /**
     * 获取对应用户的菜单权限
     * @param string $applicationName 应用名称
     * @param integer $userId 用户 ID
     * @return array
     */
    public function getButtons($applicationName, $userId, $frontendPath):array;


    /**
     * 获取对应路由的接口权限结果
     * @param $path string 请求 URL 路径
     * @param $method string 路由名字
     * @param $applicationName string 应用名字
     * @param $userId integer  用户 ID
     * @return bool
     */
    public function authByRouter($applicationName, $path, $method, $userId):  bool;

    /**
     * @param string $appName 应用名称
     * @param integer $userId 用户 ID
     * @param array $buttonCodes
     * @return array
     */
    public function getAppBtnAccess($appName, $userId, $buttonCodes = []): array;


    /**
     * 获取指定用户数据权限
     * @param $uid 用户id
     * @param $code
     * @param $appName 应用名称
     */
    public function getUserDataAuth($uid,$code,$appName);


    /**
     * 获取用户领导的部门id数组 (包含正副职管理者)
     * @param $userId
     * @return array
     */
    public function leadDeptIds($userId);


    /**
     * 获取用户领导的团队id数组
     * @param $userIds
     * @return array
     */
    public function leadTeamIdsByUsers($userIds);


    /**
     * 判断是否是管理员
     * @param $userId
     * @return bool
     */
    public function isAdmin($userId): bool;


    /**
     * 获取用户对应权限角色名称列表
     * @param $userId
     * @return array
     */
    public function getUserRoleNames($userId): array;
}
