<?php

namespace Meibuyu\Rpc\Service\Interfaces\Production;

interface ProductionServiceInterface
{

    /**
     * 生产单批次发货入库回调
     * @param array $params
     * [
     *   'production_no' => 'SC20201218-001-001', // 生产单号,必须
     *   'auth' => Auth::user(), // 当前用户,必须
     *   'warehousing_order' => [
     *     'id' => '123', // 入库单id,必须
     *     'warehousing_no' => 'RK-20200727-001', // 入库单号,必须
     *     'count' => '123', // 入库数量, 必须
     *   ]
     * ]
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function warehousingCallback(array $params);

    /**
     * 通过入库单id获取相关数据
     * @param array $warehousingOrderIds 默认去重
     * @return array 默认keyBy
     */
    public function getInfoForWarehousingOrder(array $warehousingOrderIds);

    /**
     * 通过生产单号获取生产单工厂信息
     * @param array $productionNoList 生产单号数组,默认去重
     * @return array 'production_no' => ['factory_id' => 1, 'factory_name' => 'AL']
     * @author Zero
     */
    public function getFactoryByProductionNoList(array $productionNoList): array;

    /**
     * 查询备货计划中是否用过仓库子产品
     * @param array $ids 仓库子产品id数组,默认去重
     * @return array 返回用过的id数组
     */
    public function searchUsedProductChildId($ids);

    /**
     * 查询备货计划中是否用过平台子产品
     * @param array $ids 平台子产品id数组,默认去重
     * @return array 返回用过的id数组
     */
    public function searchUsedPlatformProductChildId($ids);

    /**
     * 通过生产单号获取生产单产品数据
     * @param $productionNo
     * @return array
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function getProductionProductInfoByNo($productionNo): array;

    /**
     * 仓库返工出库回调
     * @param array $params
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function exWarehouseCallback(array $params);



    /**
     * 获取生产单留言信息
     * @param array $params
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function  productionMessages($params);


    /**
     * 生产单留言操作
     * @param array $params
     * @throws \Meibuyu\Rpc\Exceptions\RpcException
     * @author Zero
     */
    public function  toMessage($params);

    /**
     * 获取生产单列表是否有未读消息
     * @param $productionNoArr
     * @param string $source
     */
    public function getListMessageReadStatus($productionNoArr,$source='factory');

    /**
     * 更新备货计划产品工艺单维护信息
     * @param $productId 产品id
     * @param $status 工艺维护状态 0未维护，1已维护，2部分维护
     * @return mixed
     */
    public function productCraftMaintain($productId,$status);

    /**
     * 获取生产单信息
     * @param $productionOrderId
     * @param array $columns
     * @return mixed
     */
    public function productionInfo($productionOrderId,$columns = ['*']);

}
