<?php

/**
 * 供应链礼服备货小货生产单rpc服务
 */

namespace Meibuyu\Rpc\Service\Interfaces\Production;


interface ExternalProductionServiceInterface
{

    /**
     * 生产单列表
     * @return mixed
     * @param $params
     * @author Liu lu
     * date 2022-11-10
     */
    public function productionList($params);

    /**
     * 生产单列表标签
     * @param $params
     * @author Liu lu
     * date 2022-11-10
     */
    public function productionTabList($params);


    /**
     * 生产单查看详情
     * @author Liu lu
     * date 2022-11-11
     */
    public function productionView($id);

    /**
     * Notes: 小货接单
     * User: carlos
     * DateTime: 2022/11/16 14:53
     * @param $params
     */
    public function ordering($params);

    /**
     * Notes: 确认返修
     * User: carlos
     * DateTime: 2022/11/16 15:00
     * @param $params
     */
    public function repair($params);



    /**
     * 日志列表
     * @param $params
     * @author Lin jixin
     * date 2022/11/30 11:11
     */
    public function getExternalLog($params);


    /**
     * 小货对账单
     * @param $params
     * @author Lin jixin
     * date 2022/12/1 16:29
     */
    public function getExternalBillList($params);



    /**
     * 分派中心订单到仓跟进中心
     * @param $params
     * @author Lin jixin
     * date 2022/12/19 16:35
     */
    public function getApportionOrderToStoreList($params);



    /**
     * 分派中心订单到仓跟进中心tab
     * @param $params
     * @author Lin jixin
     * date 2022/12/19 16:35
     */
    public function getApportionOrderToStoreTab($params);


    /**
     * 分派中心订单到仓跟进中心回显
     * @param $params
     * @author Lin jixin
     * date 2022/12/19 16:35
     */
    public function viewApportionOrderbyId($params);


    /**
     * 分派中心订单到仓跟进中心下载发货单
     * @param $params
     * @author Lin jixin
     * date 2022/12/19 16:35
     */
    public function downloadDeliveryOrder($params);
}