<?php

declare(strict_types=1);

namespace Meibuyu\Rpc\Service\Interfaces\DatacenterNew;


/**
 * @author chentianyu
 */
interface StockPlanServiceInterface
{

    /**
     * 获取历史销量分页
     * @param array $params ['year'=>2013,'sku'=>'aabbcc']
     * @return mixed
     * @author chentianyu
     */
    public function getProductChildrenHistorySalePaginate(array $params);

    /**
     * 导出历史销量
     * @param array $params ['year'=>2013,'sku'=>'aabbcc']
     * @return mixed
     * @author chentianyu
     */
    public function exportProductChildrenHistorySale(array $params);

    /**
     * 获取预测销量分页
     * @param array $params ['year'=>2013,'sku'=>'aabbcc']
     * @return mixed
     * @author chentianyu
     */
    public function getProductEstimateSalePaginate(array $params);

    /**
     * 导出预测销量
     * @param array $params ['year'=>2013,'sku'=>'aabbcc']
     * @return mixed
     * @author chentianyu
     */
    public function exportProductEstimateSale(array $params);

    /**
     * 获取月度历史销量
     * @param array $params eg: ['product_id'=>123,'product_child_id'=>1236,'start_month'=>'2023-01','end_month'=>'2023-08']
     * @return array eg: {"2023-01": "34232","2023-02": "23432"}
     * @author chentianyu
     */
    public function getMonthHistorySale(array $params);

    /**获取月度预测销量
     * @param array $params eg: ['product_id'=>123,'start_month'=>'2023-01','end_month'=>'2023-08']
     * @return array eg: {"2023-01": "34232","2023-02": "23432"}
     * @author chentianyu
     */
    public function getMonthEstimateSale(array $params);

    /**
     * 更新平台产品预测销量
     * @param int $userId    用户id
     * @param int $siteId    站点id
     * @param int $productId 仓库主产品id
     * @param array $estimateSale  eg:[ '2023-05-01' => 1, '2023-06-01' => 2, '2023-07-01' => 1, '2023-08-01' => 1 ]
     * @return bool ture
     * @throws \Throwable
     * @author chentianyu
     */
    public function updateSiteProductEstimateSale($userId, $siteId, $productId,array $estimateSale);


}