<?php
/**
 * Created by PhpStorm.
 * User: 王源
 * Date: 2020/1/9
 * Time: 15:07
 */

namespace Meibuyu\Micro\Service\Interfaces\Product;

interface PlatformProductChildServiceInterface
{

    /**
     * 获取单个数据
     * @param int $id 平台产品id
     * @param array $relations 平台子产品的关联关系，支持：["platform_product","product_child"]
     * @param array $columns 平台子产品表的字段，默认['id','platform_product_id','product_child_id','platform_product_child_sku','asin','fnsku','is_sale']
     * @return array
     */
    public function get($id, array $relations = []
        , $columns = ['id', 'platform_product_id', 'product_child_id', 'platform_product_child_sku', 'asin', 'fnsku', 'is_sale']): array;

    /**
     * 通过id列表获取平台子产品数组
     * @param array $idList 平台子产品id的列表
     * @param array $relations 平台子产品的关联关系，支持：["platform_product","product_child"]
     * @param array $columns 平台子产品表的字段，默认['id','platform_product_id','product_child_id','platform_product_child_sku','asin','fnsku','is_sale']
     * @return array
     */
    public function getByIdList(array $idList, array $relations = []
        , $columns = ['id', 'platform_product_id', 'product_child_id', 'platform_product_child_sku', 'asin', 'fnsku', 'is_sale']): array;
}
